--- huge lua stuff ---
local tCurrentStats = THEME:GetMetric(Var "LoadingScreen","Summary") and STATSMAN:GetAccumPlayedStageStats() or STATSMAN:GetCurStageStats()
local sSong = GAMESTATE:GetCurrentSong();
local sCourse = GAMESTATE:GetCurrentCourse();
local sCurrent = GAMESTATE:IsCourseMode() and sCourse or sSong;
local bShow = THEME:GetMetric(Var "LoadingScreen","Summary");

local function GetPlayerStats(pn)
	return tCurrentStats:GetPlayerStageStats(pn);
end

local function PlayerPercentage(pn)
	local stats = GetPlayerStats(pn);
	return LoadFont("Common Normal") .. {
		BeginCommand=function(self)
			self:NoStroke();
			self:settext( FormatPercentScore( stats:GetPercentDancePoints() ) );
		end;
	};
end

local function PlayerGrade(pn)
	local stats = GetPlayerStats(pn);
		return LoadActor("grades") .. { 
		BeginCommand=function(self)
			local GradeFrames = { --taken from pro, modify as needed.
				Grade_Tier01 = 0, -- AAAA
				Grade_Tier02 = 1, -- AAA
				Grade_Tier03 = 2, -- AA
				Grade_Tier04 = 3, -- A
				Grade_Tier05 = 4, -- B
				Grade_Tier06 = 5, -- C
				Grade_Tier07 = 6, -- D
				Grade_Failed = 7, -- E
			}
			self:animate(false);
			local Grade = GradeFrames[stats:GetGrade()];
			self:setstate(Grade or 7);
		end
	};
end

local function PlayerStatLine(line,pn)
	local stats = GetPlayerStats(pn);
	return LoadFont("Common Normal") .. {
		BeginCommand=function(self)
			self:NoStroke();
			local statline = stats:GetTapNoteScores(line);
			self:settext(string.format("%04i",statline));
		end
	};
end

local function PlayerStatLineHold(line,pn)
	local stats = GetPlayerStats(pn);
	return LoadFont("Common Normal") .. {
		BeginCommand=function(self)
			self:NoStroke();
			local statline = stats:GetHoldNoteScores(line);
			self:settext(string.format("%04i",statline));
		end
	};
end

local function PlayerStatCombo(pn)
	local stats = GetPlayerStats(pn);
	return LoadFont("Common Normal") .. {
		BeginCommand=function(self)
			self:NoStroke();
			local statline = stats:MaxCombo();
			self:settext(string.format("%04i",statline));
		end
	};
end

local function GraphDisplay( pn )
	local t = Def.ActorFrame {
		Def.GraphDisplay {
			InitCommand=cmd(Load,"GraphDisplay";draworder,99);
			BeginCommand=function(self)
				local ss = SCREENMAN:GetTopScreen():GetStageStats();
				self:Set( ss, ss:GetPlayerStageStats(pn) );
				self:player( pn );
			end
		};
	};
	return t;
end

--[[ this shit is BROKEN ]]
local function LifeGraph(pn)
	--[[
	return Def.ActorFrame {
		Def.Quad {
			InitCommand=cmd(zoomto,160,36);
		};
		Def.GraphDisplay {
			OnCommand=function(self)
				local Stats = STATSMAN:GetCurStageStats();
				self:LoadFromStats( Stats, Stats:GetPlayerStageStats(Player) )
			end,
			Texture = LoadActor("life texture") .. {
				InitCommand=cmd(ztest,1);
			},
			Line = Def.GraphLine { InitCommand=cmd(visible,false) },
			Body = Def.GraphBody { InitCommand=cmd(zwrite,1;blend,"BlendMode_NoEffect") },
			SongBoundary = Def.Actor { InitCommand=cmd(visible,false) },
			Barely = Def.Actor { InitCommand=cmd(visible,false) },
		};
		LoadActor("life frame");
	};
	--]]
	return Def.ActorFrame{};
end

local function PlayerPersonalAward(pn)
	local stats = GetPlayerStats(pn);
	return LoadFont("Common Normal") .. {
		BeginCommand=function(self)
			self:NoStroke();
			local iScoreIndex = stats:GetPersonalHighScoreIndex();
			if iScoreIndex > 0 then
				self:settext("Personal Record #" .. (iScoreIndex+1));
				self:visible(true);
			else
				self:visible(false);
			end;
		end
	};
end

local function PlayerMachineAward(pn)
	local stats = GetPlayerStats(pn);
	return LoadFont("Common Normal") .. {
		BeginCommand=function(self)
			self:NoStroke();
			local iScoreIndex = stats:GetMachineHighScoreIndex();
			if iScoreIndex > 0 then
				self:settext("Machine Record #" .. (iScoreIndex+1));
				self:visible(true);
			else
				self:visible(false);
			end
		end
	};
end

-- frame
local t = LoadFallbackB();
t[#t+1] = Def.ActorFrame {
	LoadSongBackground() .. {
		InitCommand=cmd(blend,bmAdd);
		OnCommand=cmd(diffusealpha,0;linear,0.5;diffusealpha,0.25;);
		OffCommand=cmd(linear,0.3;diffusealpha,0);
	};
};
-- p1
t[#t+1] = Def.ActorFrame {
 InitCommand=cmd(player,PLAYER_1);
	PlayerGrade(PLAYER_1) .. {
		InitCommand=cmd(x,SCREEN_CENTER_X-200;y,SCREEN_TOP+100);
	};
	PlayerPercentage(PLAYER_1) .. {
		InitCommand=cmd(x,SCREEN_CENTER_X-200;y,SCREEN_TOP+156;shadowlength,1);
	};
	LoadActor(THEME:GetPathG("Player","Combo/_background")) .. {
		InitCommand=cmd(x,SCREEN_CENTER_X-200;y,SCREEN_TOP+156+20);
		OnCommand=cmd(zoom,0.5;skewx,-0.3;fadeleft,1;shadowlength,1;diffuse,JudgeColor("TapNoteScore_W1"));
	};
	PlayerStatLine("TapNoteScore_W1",PLAYER_1) .. {
		InitCommand=cmd(x,SCREEN_CENTER_X-200;y,SCREEN_TOP+156+20);
		OnCommand=cmd(zoom,0.5;shadowlength,1);
	};
	LoadActor(THEME:GetPathG("Player","Combo/_background")) .. {
		InitCommand=cmd(x,SCREEN_CENTER_X-200;y,SCREEN_TOP+156+40);
		OnCommand=cmd(zoom,0.5;skewx,-0.3;fadeleft,1;shadowlength,1;diffuse,JudgeColor("TapNoteScore_W2"));
	};
	PlayerStatLine("TapNoteScore_W2",PLAYER_1) .. {
		InitCommand=cmd(x,SCREEN_CENTER_X-200;y,SCREEN_TOP+156+40);
		OnCommand=cmd(zoom,0.5;shadowlength,1);
	};
	LoadActor(THEME:GetPathG("Player","Combo/_background")) .. {
		InitCommand=cmd(x,SCREEN_CENTER_X-200;y,SCREEN_TOP+156+60);
		OnCommand=cmd(zoom,0.5;skewx,-0.3;fadeleft,1;shadowlength,1;diffuse,JudgeColor("TapNoteScore_W3"));
	};
	PlayerStatLine("TapNoteScore_W3",PLAYER_1) .. {
		InitCommand=cmd(x,SCREEN_CENTER_X-200;y,SCREEN_TOP+156+60);
		OnCommand=cmd(zoom,0.5;shadowlength,1);
	};
	LoadActor(THEME:GetPathG("Player","Combo/_background")) .. {
		InitCommand=cmd(x,SCREEN_CENTER_X-200;y,SCREEN_TOP+156+80);
		OnCommand=cmd(zoom,0.5;skewx,-0.3;fadeleft,1;shadowlength,1;diffuse,JudgeColor("TapNoteScore_W4"));
	};
	PlayerStatLine("TapNoteScore_W4",PLAYER_1) .. {
		InitCommand=cmd(x,SCREEN_CENTER_X-200;y,SCREEN_TOP+156+80);
		OnCommand=cmd(zoom,0.5;shadowlength,1);
	};
	LoadActor(THEME:GetPathG("Player","Combo/_background")) .. {
		InitCommand=cmd(x,SCREEN_CENTER_X-200;y,SCREEN_TOP+156+100);
		OnCommand=cmd(zoom,0.5;skewx,-0.3;fadeleft,1;shadowlength,1;diffuse,JudgeColor("TapNoteScore_W5"));
	};
	PlayerStatLine("TapNoteScore_W5",PLAYER_1) .. {
		InitCommand=cmd(x,SCREEN_CENTER_X-200;y,SCREEN_TOP+156+100);
		OnCommand=cmd(zoom,0.5;shadowlength,1);
	};
	LoadActor(THEME:GetPathG("Player","Combo/_background")) .. {
		InitCommand=cmd(x,SCREEN_CENTER_X-200;y,SCREEN_TOP+156+120);
		OnCommand=cmd(zoom,0.5;skewx,-0.3;fadeleft,1;shadowlength,1;diffuse,JudgeColor("TapNoteScore_W1"));
	};
	PlayerStatLineHold("HoldNoteScore_Held",PLAYER_1) .. {
		InitCommand=cmd(x,SCREEN_CENTER_X-200;y,SCREEN_TOP+156+120);
		OnCommand=cmd(zoom,0.5;shadowlength,1);
	};
	LoadActor(THEME:GetPathG("Player","Combo/_background")) .. {
		InitCommand=cmd(x,SCREEN_CENTER_X-200;y,SCREEN_TOP+156+140);
		OnCommand=cmd(zoom,0.5;skewx,-0.3;fadeleft,1;shadowlength,1;diffuse,JudgeColor("TapNoteScore_Miss"));
	};
	PlayerStatLineHold("HoldNoteScore_LetGo",PLAYER_1) .. {
		InitCommand=cmd(x,SCREEN_CENTER_X-200;y,SCREEN_TOP+156+140);
		OnCommand=cmd(zoom,0.5;shadowlength,1);
	};
	LoadActor(THEME:GetPathG("Player","Combo/_background")) .. {
		InitCommand=cmd(x,SCREEN_CENTER_X-200;y,SCREEN_TOP+156+164);
		OnCommand=cmd(skewx,-0.3;fadeleft,1;shadowlength,1;diffuse,PlayerColor(PLAYER_1));
	};
	PlayerStatCombo(PLAYER_1) .. {
		InitCommand=cmd(x,SCREEN_CENTER_X-200;y,SCREEN_TOP+156+164);
		OnCommand=cmd(shadowlength,1);
	};
	GraphDisplay(PLAYER_1) .. {
		InitCommand=cmd(x,SCREEN_CENTER_X-200-24;y,SCREEN_BOTTOM-80+22;draworder,99);
	};
	PlayerPersonalAward(PLAYER_1) .. {
		InitCommand=cmd(x,SCREEN_CENTER_X-200-24;y,SCREEN_BOTTOM-80-22);
		OnCommand=cmd(zoom,0.5;shadowlength,1);
	};
	PlayerMachineAward(PLAYER_1) .. {
		InitCommand=cmd(x,SCREEN_CENTER_X-200-24;y,SCREEN_BOTTOM-80);
		OnCommand=cmd(zoom,0.5;shadowlength,1);
	};
};

t[#t+1] = Def.ActorFrame {
 InitCommand=cmd(player,PLAYER_2);
	PlayerGrade(PLAYER_2) .. {
		InitCommand=cmd(x,SCREEN_CENTER_X+200;y,SCREEN_TOP+100);
	};
	PlayerPercentage(PLAYER_2) .. {
		InitCommand=cmd(x,SCREEN_CENTER_X+200;y,SCREEN_TOP+156;shadowlength,1);
	};
	LoadActor(THEME:GetPathG("Player","Combo/_background")) .. {
		InitCommand=cmd(x,SCREEN_CENTER_X+200;y,SCREEN_TOP+156+20);
		OnCommand=cmd(zoom,0.5;skewx,0.3;faderight,1;shadowlength,0;diffuse,JudgeColor("TapNoteScore_W1"));
	};
	PlayerStatLine("TapNoteScore_W1",PLAYER_2) .. {
		InitCommand=cmd(x,SCREEN_CENTER_X+200;y,SCREEN_TOP+156+20);
		OnCommand=cmd(zoom,0.5;shadowlength,1);
	};
	LoadActor(THEME:GetPathG("Player","Combo/_background")) .. {
		InitCommand=cmd(x,SCREEN_CENTER_X+200;y,SCREEN_TOP+156+40);
		OnCommand=cmd(zoom,0.5;skewx,0.3;faderight,1;shadowlength,0;diffuse,JudgeColor("TapNoteScore_W2"));
	};
	PlayerStatLine("TapNoteScore_W2",PLAYER_2) .. {
		InitCommand=cmd(x,SCREEN_CENTER_X+200;y,SCREEN_TOP+156+40);
		OnCommand=cmd(zoom,0.5;shadowlength,1);
	};
	LoadActor(THEME:GetPathG("Player","Combo/_background")) .. {
		InitCommand=cmd(x,SCREEN_CENTER_X+200;y,SCREEN_TOP+156+60);
		OnCommand=cmd(zoom,0.5;skewx,0.3;faderight,1;shadowlength,0;diffuse,JudgeColor("TapNoteScore_W3"));
	};
	PlayerStatLine("TapNoteScore_W3",PLAYER_2) .. {
		InitCommand=cmd(x,SCREEN_CENTER_X+200;y,SCREEN_TOP+156+60);
		OnCommand=cmd(zoom,0.5;shadowlength,1);
	};
	LoadActor(THEME:GetPathG("Player","Combo/_background")) .. {
		InitCommand=cmd(x,SCREEN_CENTER_X+200;y,SCREEN_TOP+156+80);
		OnCommand=cmd(zoom,0.5;skewx,0.3;faderight,1;shadowlength,0;diffuse,JudgeColor("TapNoteScore_W4"));
	};
	PlayerStatLine("TapNoteScore_W4",PLAYER_2) .. {
		InitCommand=cmd(x,SCREEN_CENTER_X+200;y,SCREEN_TOP+156+80);
		OnCommand=cmd(zoom,0.5;shadowlength,1);
	};
	LoadActor(THEME:GetPathG("Player","Combo/_background")) .. {
		InitCommand=cmd(x,SCREEN_CENTER_X+200;y,SCREEN_TOP+156+100);
		OnCommand=cmd(zoom,0.5;skewx,0.3;faderight,1;shadowlength,0;diffuse,JudgeColor("TapNoteScore_W5"));
	};
	PlayerStatLine("TapNoteScore_W5",PLAYER_2) .. {
		InitCommand=cmd(x,SCREEN_CENTER_X+200;y,SCREEN_TOP+156+100);
		OnCommand=cmd(zoom,0.5;shadowlength,1);
	};
	LoadActor(THEME:GetPathG("Player","Combo/_background")) .. {
		InitCommand=cmd(x,SCREEN_CENTER_X+200;y,SCREEN_TOP+156+120);
		OnCommand=cmd(zoom,0.5;skewx,0.3;faderight,1;shadowlength,0;diffuse,JudgeColor("TapNoteScore_W1"));
	};
	PlayerStatLineHold("HoldNoteScore_Held",PLAYER_2) .. {
		InitCommand=cmd(x,SCREEN_CENTER_X+200;y,SCREEN_TOP+156+120);
		OnCommand=cmd(zoom,0.5;shadowlength,1);
	};
	LoadActor(THEME:GetPathG("Player","Combo/_background")) .. {
		InitCommand=cmd(x,SCREEN_CENTER_X+200;y,SCREEN_TOP+156+140);
		OnCommand=cmd(zoom,0.5;skewx,0.3;faderight,1;shadowlength,0;diffuse,JudgeColor("TapNoteScore_Miss"));
	};
	PlayerStatLineHold("HoldNoteScore_LetGo",PLAYER_2) .. {
		InitCommand=cmd(x,SCREEN_CENTER_X+200;y,SCREEN_TOP+156+140);
		OnCommand=cmd(zoom,0.5;shadowlength,1);
	};
	LoadActor(THEME:GetPathG("Player","Combo/_background")) .. {
		InitCommand=cmd(x,SCREEN_CENTER_X+200;y,SCREEN_TOP+156+164);
		OnCommand=cmd(skewx,0.3;faderight,1;shadowlength,0;diffuse,PlayerColor(PLAYER_2));
	};
	PlayerStatCombo(PLAYER_2) .. {
		InitCommand=cmd(x,SCREEN_CENTER_X+200;y,SCREEN_TOP+156+164);
		OnCommand=cmd(shadowlength,1);
	};
	GraphDisplay(PLAYER_2) .. {
		InitCommand=cmd(x,SCREEN_CENTER_X+200+24;y,SCREEN_BOTTOM-80+22;draworder,99);
	};
	PlayerPersonalAward(PLAYER_2) .. {
		InitCommand=cmd(x,SCREEN_CENTER_X+200+24;y,SCREEN_BOTTOM-80-22);
		OnCommand=cmd(zoom,0.5;shadowlength,1);
	};
	PlayerMachineAward(PLAYER_2) .. {
		InitCommand=cmd(x,SCREEN_CENTER_X+200+24;y,SCREEN_BOTTOM-80);
		OnCommand=cmd(zoom,0.5;shadowlength,1);
	};
};
-- banner [ Single ]
t[#t+1] = Def.ActorFrame {
 InitCommand=cmd(x,SCREEN_CENTER_X;y,SCREEN_BOTTOM-80;draworder,95;hidden,bShow);
	Def.Sprite {
		InitCommand=cmd();
		BeginCommand=function(self)
			local banner = sCurrent:GetBannerPath();
			if banner == nil then
				self:LoadBanner( THEME:GetPathG("Common","fallback banner") );
			else
				self:LoadBanner( banner );
			end
			self:scaletoclipped(256, 80);
		end;
	};
	LoadActor( "banner frame" );
};
-- banner clones [ Multi ]
if bShow then
	local function MakeBanners(StagesAgo)
		local Current;
		local CurrentPart = {}
		local Stats = STATSMAN:GetPlayedStageStats(StagesAgo);
		if GAMESTATE:IsCourseMode() then
			Current = GAMESTATE:GetCurrentCourse();
		else
			Current = Stats:GetPlayedSongs()[1];
		end
		assert(Current);

		local sBannerPath = Current:GetBannerPath() or THEME:GetPathG("Common","fallback banner");

		local t = Def.ActorFrame {};
		t[#t+1] = 	Def.Sprite {
			InitCommand=cmd(y,100+(80*((PREFSMAN:GetPreference("SongsPerPlay")) - StagesAgo)));
			BeginCommand=function(self)
				local banner = sCurrent:GetBannerPath();
				if banner == nil then
					self:LoadBanner( THEME:GetPathG("Common","fallback banner") );
				else
					self:LoadBanner( sBannerPath );
				end
				self:scaletoclipped(256, 80);
			end;
		};

		return t
	end
	local z = Def.ActorFrame {};

	for i = 1,PREFSMAN:GetPreference("SongsPerPlay") do
		z[#z+1] = MakeBanners(i) .. {
			Name="Row" .. tostring(i);
			InitCommand=cmd(x,SCREEN_CENTER_X);
		};
		z[#z+1] = LoadFont("Common Normal") .. {
			InitCommand=cmd(x,SCREEN_CENTER_X;y,80*i;settext,"Stage "..tonumber(i);NoStroke;shadowlength,1;zoom,0.5;);
		};
		z[#z+1] = LoadActor( "banner frame" ) .. { InitCommand=cmd(x,SCREEN_CENTER_X;y,(80*i)); };
	end

	t[#t+1] = z
end


return t